#!/bin/bash

#ESPTOOL_BAUD=2000000

while true; do
	echo -e "\e[96m"
	echo "Install Coolhardware.de ElecPow 2.x (for ESP32)"
	echo -e "\e[97m"
	echo "i - Display flash chip information"
	echo "b - Create backup of current firmware"
	echo "r - Restore backup"
	echo "q - Quit"
	echo -e "\e[96m"
	echo "Flash ElecPow with the following default pin configuration."
	echo "You can change the pin configuration via the web interface at any time:"
	echo -e "\e[97m"
	echo "0 - Generic ESP32 without preset"
	echo "1 - Sonoff Dual R3 (V2.0)"
	echo "2 - Sonoff Pow Elite"
	echo "3 - Liligo TTGO T-Display"
	echo "4 - Shelly Plus 1PM"
	echo "5 - Generic ESP32-S3 without preset (experimental)"
	echo -e "\e[0m"

	read -p "Please choose an option: " choice

	case $choice in
		i)
			./esptool flash_id;;

		b)
			if [ -e "backup.bin" ]; then
				echo "The file backup.bin is already present!"
			else
				./esptool read_flash 0 all backup.bin
			fi;;

		r)
			./esptool write_flash --flash_size detect --erase-all 0 backup.bin && exit;;

		q)
			exit;;

		0)
			./esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 ESP32.bin && exit;;

		1)
			./esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 SONOFF_DUAL_R3.bin && exit;;

		2)
			./esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 SONOFF_POW_ELITE.bin && exit;;

		3)
			./esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 TTGO.bin && exit;;

		4)
			./esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_single.bin 0x08000 partition-table.bin 0x10000 SHELLY_PLUS_1PM.bin && exit;;

		5)
			./esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_s3.bin 0x08000 partition-table.bin 0x10000 ESP32_S3.bin && exit;;

		*)
			echo "Invalid option";;
	esac
done
