@echo off
::set ESPTOOL_BAUD=2000000
:menu
echo [96m
echo Install Coolhardware.de ElecPow 2.x (for ESP32)
echo [97m
echo i - Display flash chip information
echo b - Create backup of current firmware
echo r - Restore backup
echo q - Quit
echo [96m
echo Flash ElecPow with the following default pin configuration.
echo You can change the pin configuration via the web interface at any time:
echo [97m
echo 0 - Generic ESP32 without preset
echo 1 - Sonoff Dual R3 (V2.0)
echo 2 - Sonoff Pow Elite
echo 3 - Liligo TTGO T-Display
echo 4 - Shelly Plus 1PM
echo 5 - Generic ESP32-S3 without preset (experimental)
echo [0m
choice /n /c:qibr012345 /M "Please choose an option:"
GOTO menu-%ERRORLEVEL%

:menu-1
goto end

:menu-2
esptool flash_id
goto menu

:menu-3
if exist backup.bin (
 echo "The file backup.bin is already present!"
) else (
 esptool read_flash 0 all backup.bin
)
goto menu

:menu-4
esptool write_flash --flash_size detect --erase-all 0 backup.bin
if errorlevel 1 goto menu
goto end

:menu-5
esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 ESP32.bin
if errorlevel 1 goto menu
goto end

:menu-6
esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 SONOFF_DUAL_R3.bin
if errorlevel 1 goto menu
goto end

:menu-7
esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 SONOFF_POW_ELITE.bin
if errorlevel 1 goto menu
goto end

:menu-8
esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_dual.bin 0x08000 partition-table.bin 0x10000 TTGO.bin
if errorlevel 1 goto menu
goto end

:menu-9
esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_single.bin 0x08000 partition-table.bin 0x10000 SHELLY_PLUS_1PM.bin
if errorlevel 1 goto menu
goto end

:menu-10
esptool write_flash --flash_mode dio --flash_freq 40m --flash_size detect --erase-all 0x01000 boot_s3.bin 0x08000 partition-table.bin 0x10000 ESP32_S3.bin
if errorlevel 1 goto menu
goto end

:end
